/**
 * Beschrijft een cowboypersonage van een computergame.
 * 
 * @author Dominiek Vandewalle
 * @version 2016-04-12
 */
public class Cowboy implements Strijder
{
    private int aantalLevens;
    private int gezondheid;
    private String naam;
    
    /**
     * Constructor voor objecten van de klasse Cowboy.
     * @param   naam    De naam van de cowboy.
     */
    public Cowboy(String naam)
    {
       this.naam = naam;
       aantalLevens = MAXIMUMLEVENS;
       gezondheid = 100;
    }
    
    /**
     * Vermindert de gezonheidstoestand van de cowboy.
     */
    public void geraakt()
    {
        gezondheid = Math.max(0, gezondheid - 40);
        
        if(gezondheid == 0 && aantalLevens > 0)
        {
            aantalLevens--;
            gezondheid = 100;
        }
    }
    
    /**
     * Schiet naar een andere strijder.
     * @param   tegenstander    De strijder die beschoten wordt.
     */
    public void schiet(Strijder tegenstander)
    {
        if(gezondheid > 0)
        {
            tegenstander.geraakt();
        }
    }
    
    /**
     * Whisky drinken is slecht voor de gezondheid.
     */
    public void drinkWhisky()
    {
        if(gezondheid != 0)
        {
            geraakt();
        }
    }
    
    /**
     * Toont de gezondheidsstatus van de cowboy in het terminalvenster.
     */
    public void printInfo()
    {
        System.out.println("Naam: " + naam);
        System.out.println("Levens: " + aantalLevens);
        System.out.println("Gezondheid: " + gezondheid);
    }
}
